#define sign(r) ((r>0)?1:((r<0)?-1:0))

double  getBondLen(int a, int b)
{
   double q;
   double Xa,Ya,Za;
   if (a<0 || b<0) {
       printf("Errorous atom coordinates.\n");
       return 0;
   }
   Xa= atoms[a].x-atoms[b].x;
   Ya= atoms[a].y-atoms[b].y;
   Za= atoms[a].z-atoms[b].z;
   q = Xa*Xa+Ya*Ya+Za*Za;
//   printf("bond length %d - %d = %g\n",a+1,b+1,sqrt(q));
   if (q<=0) {
       printf("Zero bond length (%d,%d)\n",a+1,b+1);
       return 0;
   }
   else return sqrt(q);
}

double  getAngle(int a, int centr, int b)
{
  double q,p;
  double Xa,Ya,Za;
  double Xb,Yb,Zb;
  if (a<0 || b<0 || centr<0) { printf("Errorous atom coordinates.\n"); return 0; }
  Xa= atoms[a].x-atoms[centr].x;
  Ya= atoms[a].y-atoms[centr].y;
  Za= atoms[a].z-atoms[centr].z;
  Xb= atoms[b].x-atoms[centr].x;
  Yb= atoms[b].y-atoms[centr].y;
  Zb= atoms[b].z-atoms[centr].z;
  q = Xa*Xa+Ya*Ya+Za*Za;
  p = Xb*Xb+Yb*Yb+Zb*Zb;
  if (q <=0) {
      printf("Atoms on single line B1(%d,%d)\n",a+1,centr+1);
      return 0;
  }
  if (p <=0) {
      printf("Atoms on single line B2(%d,%d)\n",b+1,centr+1);
      return 0;
  }
  return 180.0/PI*acos((Xa*Xb+Ya*Yb+Za*Zb)/sqrt(p)/sqrt(q));
}

double  deter(int p1, int p2, int p3)
{
    double ps;
    ps = (atoms[p2].x*atoms[p3].y - atoms[p3].x*atoms[p2].y) * atoms[p1].z +
         (atoms[p3].x*atoms[p1].y - atoms[p1].x*atoms[p3].y) * atoms[p2].z +
         (atoms[p1].x*atoms[p2].y - atoms[p2].x*atoms[p1].y) * atoms[p3].z;
    return ps;
}

double  planeA(int p1, int p2, int p3)
{
    double az;
    az = (atoms[p3].y - atoms[p2].y) * atoms[p1].z +
         (atoms[p1].y - atoms[p3].y) * atoms[p2].z +
         (atoms[p2].y - atoms[p1].y) * atoms[p3].z;
    return az;
}

double  planeB(int p1, int p2, int p3)
{
    double az;
    az = (atoms[p3].z - atoms[p2].z) * atoms[p1].x +
         (atoms[p1].z - atoms[p3].z) * atoms[p2].x +
         (atoms[p2].z - atoms[p1].z) * atoms[p3].x;
    return -az;
}

double  planeC(int p1, int p2, int p3)
{
    double az;
    az = (atoms[p3].x - atoms[p2].x) * atoms[p1].y +
         (atoms[p1].x - atoms[p3].x) * atoms[p2].y +
         (atoms[p2].x - atoms[p1].x) * atoms[p3].y;
    return az;
}

/*double  getDA(int a, int centr, int last, int point)
{
  double q,p,r, Xa,Ya,Za, Xb,Yb,Zb;
  if (a<0 || last<0 || centr<0 || point<0) { printf("Errorous atom coordinates.\n"); return 0; }

  Xa = planeA(a, centr, last);
  Ya = planeB(a, centr, last);
  Za = planeC(a, centr, last);
  Xb = planeA(centr, last, point);
  Yb = planeB(centr, last, point);
  Zb = planeC(centr, last, point);

  q = Xa*Xa+Ya*Ya+Za*Za;
  p = Xb*Xb+Yb*Yb+Zb*Zb;

  if (q<=0) { printf("COUPLED ATOMS!!! P1(%d,%d,%d)\n",a+1,centr+1,last+1); return 0; }
  if (p<=0) { printf("COUPLED ATOMS!!! P1(%d,%d,%d)\n",centr+1,last+1,point+1); return 0; }

  r=(Xa*Xb+Ya*Yb+Za*Zb)/(sqrt(q)*sqrt(p));
printf("Xa=%f Ya=%f Za=%f   Xb=%f Yb=%f Zb=%f \n q=%f p=%f  r=%f  d=%f\n",
        Xa,Ya,Za,           Xb,Yb,Zb,            q,p,       r,    acos(r));
  return 180.0/PI*acos(r);
//  return sign(r)*180.0/PI*acos(r);
}*/

double  getDA(int i1, int i2, int i3, int i4)  // Testing version from CCL
{
      double x1i,x2i,y1i,y2i,z1i,z2i,ux1,uy1,uz1,ux2,uy2,uz2,u1,u2,u,a,dihedr;

      x1i=atoms[i2].x-atoms[i1].x;
      y1i=atoms[i2].y-atoms[i1].y;
      z1i=atoms[i2].z-atoms[i1].z;
      x2i=atoms[i3].x-atoms[i2].x;
      y2i=atoms[i3].y-atoms[i2].y;
      z2i=atoms[i3].z-atoms[i2].z;
      ux1=y1i*z2i-z1i*y2i;
      uy1=z1i*x2i-x1i*z2i;
      uz1=x1i*y2i-y1i*x2i;
      x1i=atoms[i4].x-atoms[i3].x;
      y1i=atoms[i4].y-atoms[i3].y;
      z1i=atoms[i4].z-atoms[i3].z;
      ux2=z1i*y2i-y1i*z2i;
      uy2=x1i*z2i-z1i*x2i;
      uz2=y1i*x2i-x1i*y2i;

      u1=ux1*ux1+uy1*uy1+uz1*uz1;
      u2=ux2*ux2+uy2*uy2+uz2*uz2;
      u=u1*u2;

      if (u!=0.0) {
        a=(ux1*ux2+uy1*uy2+uz1*uz2)/sqrt(u);
        a=max(a,-1.0);
        a=min(a,1.0);
        dihedr=acos(a);
        if (ux1*(uy2*z2i-uz2*y2i)+
            uy1*(uz2*x2i-ux2*z2i)+
            uz1*(ux2*y2i-uy2*x2i) < 0.0) {dihedr =-dihedr;}
        return 180.0/PI*dihedr;
      } else {
        printf("Error in dihedral (%d,%d,%d,%d)\n",i1+1,i2+1,i3+1,i4+1);
      }
}

void    rotxyz (int a, int b, int c, double theta, GLfloat A[4][4])
{
      GLfloat    ct,st,B[9];

      ct = cos(PI*theta/180.0);
      st = sin(PI*theta/180.0);

      B[0] = A[0][0]*(a+ct*(1-a)) + A[0][1]*(  st*c)     + A[0][2]*( -st*b);
      B[1] = A[0][0]*( -st*c)     + A[0][1]*(b+ct*(1-b)) + A[0][2]*(  st*a);
      B[2] = A[0][0]*(  st*b)     + A[0][1]*( -st*a)     + A[0][2]*(c+ct*(1-c));

      B[3] = A[1][0]*(a+ct*(1-a)) + A[1][1]*(  st*c)     + A[1][2]*( -st*b);
      B[4] = A[1][0]*( -st*c)     + A[1][1]*(b+ct*(1-b)) + A[1][2]*(  st*a);
      B[5] = A[1][0]*(  st*b)     + A[1][1]*( -st*a)     + A[1][2]*(c+ct*(1-c));

      B[6] = A[2][0]*(a+ct*(1-a)) + A[2][1]*(  st*c)     + A[2][2]*( -st*b);
      B[7] = A[2][0]*( -st*c)     + A[2][1]*(b+ct*(1-b)) + A[2][2]*(  st*a);
      B[8] = A[2][0]*(  st*b)     + A[2][1]*( -st*a)     + A[2][2]*(c+ct*(1-c));

      A[0][0] = B[0];
      A[0][1] = B[1];
      A[0][2] = B[2];

      A[1][0] = B[3];
      A[1][1] = B[4];
      A[1][2] = B[5];

      A[2][0] = B[6];
      A[2][1] = B[7];
      A[2][2] = B[8];
}


void revmat(GLfloat A[4][4], GLfloat B[4][4])
{
        GLfloat det;
        det =    A[0][0]*A[1][1]*A[2][2]
                -A[0][0]*A[1][2]*A[2][1]
                -A[1][0]*A[0][1]*A[2][2]
                +A[1][0]*A[0][2]*A[2][1]
                +A[2][0]*A[0][1]*A[1][2]
                -A[2][0]*A[0][2]*A[1][1];

        if (det != 0) {
                det = -1 / det;
                B[0][0] = (-A[1][1]*A[2][2]+A[1][2]*A[2][1])*det;
                B[0][1] = ( A[0][1]*A[2][2]-A[0][2]*A[2][1])*det;
                B[0][2] = (-A[0][1]*A[1][2]+A[0][2]*A[1][1])*det;
                B[1][0] = ( A[1][0]*A[2][2]-A[1][2]*A[2][0])*det;
                B[1][1] = (-A[0][0]*A[2][2]+A[0][2]*A[2][0])*det;
                B[1][2] = ( A[0][0]*A[1][2]-A[0][2]*A[1][0])*det;
                B[2][0] = (-A[1][0]*A[2][1]+A[1][1]*A[2][0])*det;
                B[2][1] = ( A[0][0]*A[2][1]-A[0][1]*A[2][0])*det;
                B[2][2] = (-A[0][0]*A[1][1]+A[0][1]*A[1][0])*det;
        } else {
                B[0][0] = 1;                B[0][1] = 0;                B[0][2] = 0;
                B[1][0] = 0;                B[1][1] = 1;                B[1][2] = 0;
                B[2][0] = 0;                B[2][1] = 0;                B[2][2] = 1;
        }
}